//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Net;
using System.Net.Sockets;

namespace Bench
{
	/// <summary>
	/// Podsumowanie dla TcpClientTest.
	/// </summary>
	public class TcpClientTest : NetworkTest
	{
		public TcpClientTest(string server, int port, int numberOfPackets, int packetSize) :
			base(server, port, numberOfPackets, packetSize)
		{
		}
		public override void Start()
		{
			TcpClient client = new TcpClient();
			client.Connect(Server, Port);
			NetworkStream stream = client.GetStream();
			byte[] writeBuffer = new byte[PacketSize];
			byte[] readBuffer = new byte[PacketSize];
			int nTransmitted;
			int nReceived;
			int nTotalReceived;

			TransmitByteCount = 0;
			ReceivedByteCount = 0;

			{
				// Wysanie pewnej liczby bajtw i sprawdzenie,
				// czy jest moliwe odesanie tych samych danych.
				Random r = new Random();
				r.NextBytes(writeBuffer);
				stream.Write(writeBuffer, 0, writeBuffer.Length);
				nTransmitted = writeBuffer.Length;
				for(nReceived = 0, nTotalReceived = 0; nTotalReceived < nTransmitted;)
				{
					nReceived = stream.Read(readBuffer, nReceived, nTransmitted - nTotalReceived);
					ReceivedByteCount += nReceived;
					nTotalReceived += nReceived;
				}
				for(int i = 0; i < writeBuffer.Length; i++)
				{
					if(writeBuffer[i] != readBuffer[i])
					{
						// Tu ley problem
						return;
					}
				}
			}

			// Wykonanie testu
			StartCounters();
			int startTime = Environment.TickCount;
			for(int i = 0; i < NumberOfPackets; i++)
			{
				// nBytes = stream.Write(writeBuffer, 0, writeBuffer.Length);
				stream.Write(writeBuffer, 0, writeBuffer.Length);
				nTransmitted = writeBuffer.Length;
				TransmitByteCount += nTransmitted;
				for(nReceived = 0, nTotalReceived = 0; nTotalReceived < nTransmitted;)
				{
					nReceived = stream.Read(readBuffer, nReceived, nTransmitted - nTotalReceived);
					ReceivedByteCount += nReceived;
					nTotalReceived += nReceived;
				}
			}
			int endTime = Environment.TickCount;
			StopCounters();

			Elapsed = endTime - startTime;

			client.Close();
		}
	}
}
